"use strict";
//
// Copyright 2020-2022 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const Native = require("../../../Native");
const Constants_1 = require("../internal/Constants");
const ExpiringProfileKeyCredentialResponse_1 = require("./ExpiringProfileKeyCredentialResponse");
class ServerZkProfileOperations {
    constructor(serverSecretParams) {
        this.serverSecretParams = serverSecretParams;
    }
    issueExpiringProfileKeyCredential(profileKeyCredentialRequest, userId, profileKeyCommitment, expirationInSeconds) {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return this.issueExpiringProfileKeyCredentialWithRandom(random, profileKeyCredentialRequest, userId, profileKeyCommitment, expirationInSeconds);
    }
    issueExpiringProfileKeyCredentialWithRandom(random, profileKeyCredentialRequest, userId, profileKeyCommitment, expirationInSeconds) {
        return new ExpiringProfileKeyCredentialResponse_1.default(Native.ServerSecretParams_IssueExpiringProfileKeyCredentialDeterministic(this.serverSecretParams.getContents(), random, profileKeyCredentialRequest.getContents(), userId.getServiceIdFixedWidthBinary(), profileKeyCommitment.getContents(), expirationInSeconds));
    }
    verifyProfileKeyCredentialPresentation(groupPublicParams, profileKeyCredentialPresentation, now = new Date()) {
        Native.ServerSecretParams_VerifyProfileKeyCredentialPresentation(this.serverSecretParams.getContents(), groupPublicParams.getContents(), profileKeyCredentialPresentation.getContents(), Math.floor(now.getTime() / 1000));
    }
}
exports.default = ServerZkProfileOperations;
//# sourceMappingURL=ServerZkProfileOperations.js.map